<?php

namespace Suiterus\Adg\Models\Payroll;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MandatoryContribution extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'mandatory_contributions';

    protected $fillable = [
        'template_id',
        'name',
        'type',
        'value',
        'status',
        'created_by',
        'updated_by',
    ];

    public function template() {
        return $this->belongsTo('Suiterus\Adg\Models\Payroll\MandatoryContributionTemplate', 'template_id', 'id');
    }
}
