<?php

namespace Suiterus\Adg\Models;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\Payroll\PayrollEmployee;

class LongevityPay extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'longevity_pays';

    protected $fillable = [
        'user_id',
        'date',
        'number',
        'salary_rate',
        'percentage',
        'latest_pay',
        'total_pay',
        'status'
    ];

    public function __construct(array $attributes = []) {
        $this->table = env('ADG_DB_DATABASE') . '.longevity_pays';
        parent::__construct($attributes);
    }

    public function user() {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function employee_payroll() {
        return $this->belongsTo(PayrollEmployee::class, 'user_id');
    }
}
