<?php

namespace Suiterus\Adg\Models\Payroll;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\LeaveManagement\Crediting\LeaveWithoutPay;

class LeaveWithoutPayDeduction extends Model
{
    use HasFactory;

    protected $connection = 'adg_db';

    protected $table = 'leave_without_pay_deductions';

    protected $fillable = [
        'payroll_employee_id',
        'leave_without_pay_id',
    ];

    public function __construct(array $attributes = []) {
        $this->table = env('ADG_DB_DATABASE') . '.leave_without_pay_deductions';
        parent::__construct($attributes);
    }

    public function employee_payroll() {
        return $this->belongsTo(PayrollEmployee::class, 'payroll_employee_id', 'id');
    }

    public function leave_without_pay() {
        return $this->belongsTo(LeaveWithoutPay::class, 'leave_without_pay_id', 'id');
    }
}
