<?php

namespace Suiterus\Adg\Models\Payroll;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LeaveRefundDetails extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'leave_refund_details';

    protected $fillable = [
        'leave_refund_id',
        'date',
        'credits',
        'amount',
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.leave_refund_details';
        parent::__construct($attributes);
    }

    public function leaveRefund() {
        return $this->belongsTo(LeaveRefund::class, 'leave_refund_id', 'id');
    }
}
