<?php

namespace Suiterus\Adg\Models\Payroll;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\LeaveManagement\Requests\Leave;

class LeaveRefund extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'leave_refunds';

    protected $fillable = [
        'user_id',
        'leave_id',
        'earning_deduction_id',
        'start_date',
        'end_date',
        'total_credits',
        'total_amount',
        'reason',
        'status'
    ];

    protected $with = [
        'leaveRefundDetails'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.leave_refunds';
        parent::__construct($attributes);
    }

    // Users
    public function user() {
        return $this->belongsTo(User::class, 'user_id','id');
    }

    public function leave() {
        return $this->belongsTo(Leave::class, 'leave_id', 'id');
    }

    public function leaveRefundDetails() {
        return $this->hasMany(LeaveRefundDetails::class, 'leave_refund_id', 'id');
    }

    public function earningDeduction() {
        return $this->belongsTo(PayrollEarningDeduction::class, 'earning_deduction_id', 'id');
    }
}
