<?php

namespace Suiterus\Adg\Models\Payroll;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Allowance extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'allowances';

    protected $fillable = [
        'title',
        'description',
        'status'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.allowances';
        parent::__construct($attributes);
    }

    // Users
    public function users() {
        return $this->belongsToMany(User::class, 'employee_allowances', 'allowance_id', 'user_id');
    }
}
