<?php

namespace Suiterus\Adg\Models\PDS;

use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\EMI\EmployeeExtraFieldColumn;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Suiterus\Adg\Models\EMI\EmployeeExtraFieldGroupHistory;

class UpdatePDS extends Model
{
    use HasFactory;

    protected $connection = 'adg_db';

    protected $table = 'new_updates_pds';

    protected $fillable = [
        'eefc_id',
        'eefg_history_id',
        'position_id',
        'field_value',
        'old_value',
        'status',
        'reason',
        'file_attachment',
        'created_by',
        'updated_by'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE').'.new_updates_pds';
        $this->connection = env('ADG_DB_CONNECTION');
        parent::__construct($attributes);
    }

    public function employeeExtraFieldColumn(){
        return $this->belongsTo(EmployeeExtraFieldColumn::class, 'eefc_id', 'id');
    }

    public function employeeExtraFieldGroupHistory(){
        return $this->belongsTo(EmployeeExtraFieldGroupHistory::class, 'eefg_history_id', 'id');
    }

}
