<?php

namespace Suiterus\Adg\Models\PDS;

use Suiterus\Adg\Models\EMI\EmployeeExtraFieldColumn;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Hrjp\Models\Position_history;

class PDSPerPosition extends Model
{
    use HasFactory;

    protected $connection = 'adg_db';

    protected $table = 'pds_per_positions';

    protected $fillable = [
        'position_history_id',
        'eefc_id',
        'field_name',
        'field_value',
        'created_by',
        'updated_by'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE').'.pds_per_positions';
        $this->connection = env('ADG_DB_CONNECTION');
        parent::__construct($attributes);
    }

    public function employeeExtraFieldColumn(){
        return $this->belongsTo(EmployeeExtraFieldColumn::class, 'eefc_id', 'id')->withTrashed();
    }

    public function positionHistory(){
        return $this->belongsTo(Position_history::class, 'position_history_id', 'id');
    }

}
