<?php

namespace Suiterus\Adg\Models\PDS;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\EMI\EmployeeExtraFieldColumn;
use Suiterus\Adg\Models\ServiceRecord\ServiceRecord;

class PDSHistory extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'pds_histories';

    protected $fillable = [
        'user_id',
        'service_record_id',
        'eefc_id',
        'field_name',
        'field_value',
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE').'.pds_histories';
        $this->connection = env('ADG_DB_CONNECTION');
        parent::__construct($attributes);
    }

    public function user(){
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function serviceRecord(){
        return $this->belongsTo(ServiceRecord::class, 'service_record_id', 'id')->where('remark_id', 26);
    }

    public function employeeExtraFieldColumn(){
        return $this->belongsTo(EmployeeExtraFieldColumn::class, 'eefc_id', 'id')->withTrashed();
    }

}
