<?php

namespace Suiterus\Adg\Models\OrgStructure;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\SPMS\PCRFormType;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class OrganizationStructurePcr extends Model
{
    use HasFactory;

    protected $fillable = [
        'pcr_form_type_id',
        'created_by',
        'updated_by',
    ];

    protected $with = [
        'pcrFormType',
        'mfos'
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.organization_structure_pcrs';
        parent::__construct($attributes);
    }

    public function pcrable()
    {
        return $this->morphTo();
    }

    public function mfos(){
        return $this->hasMany(OrganizationStructureMfo::class, 'organization_pcr_id', 'id');
    }

    public function pcrFormType()
    {
        return $this->belongsTo(PCRFormType::class, 'pcr_form_type_id');
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by')->without([
            'currentRole',
            'roles',
            'permissions',
            'storage',
            'employeeMetaInfo',
            'supervisor',
            'user_supervisor',
            'exitInterview',
            'userProfilePicture',
            'profileBasicInfo'
        ]);
    }

    public function updatedBy()
    {
        return $this->belongsTo(User::class, 'updated_by')->without([
            'currentRole',
            'roles',
            'permissions',
            'storage',
            'employeeMetaInfo',
            'supervisor',
            'user_supervisor',
            'exitInterview',
            'userProfilePicture',
            'profileBasicInfo'
        ]);
    }
}
