<?php

namespace Suiterus\Adg\Models\OrgStructure;

use Carbon\Carbon;
use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\SPMS\PCRFormType;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class OrganizationStructureOvertime extends Model
{
    use HasFactory;

    protected $fillable = [
        'minimum_overtime',
        'created_by',
        'updated_by',
    ];

    protected $appends = [
        'formatted_minimum_overtime',
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.organization_structure_ots';
        parent::__construct($attributes);
    }

    public function otable()
    {
        return $this->morphTo();
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by')->without([
            'currentRole',
            'roles',
            'permissions',
            'storage',
            'employeeMetaInfo',
            'supervisor',
            'user_supervisor',
            'exitInterview',
            'userProfilePicture',
            'profileBasicInfo'
        ]);
    }

    public function updatedBy()
    {
        return $this->belongsTo(User::class, 'updated_by')->without([
            'currentRole',
            'roles',
            'permissions',
            'storage',
            'employeeMetaInfo',
            'supervisor',
            'user_supervisor',
            'exitInterview',
            'userProfilePicture',
            'profileBasicInfo'
        ]);
    }

    public function getFormattedMinimumOvertimeAttribute(){
        return date("H:i", strtotime($this->minimum_overtime));
    }
}
