<?php

namespace Suiterus\Adg\Models\OrgStructure;

use Suiterus\Adg\Models\SPMS\Mfo;
use Illuminate\Database\Eloquent\Model;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Suiterus\Adg\Models\OrgStructure\OrganizationStructurePcr;

class OrganizationStructureMfo extends Model
{
    use HasFactory;

    protected $fillable = [
        'organization_pcr_id',
        'mfo_id',
        'percentage',
    ];

    protected $with = [
        'mfo',
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.organization_structure_mfos';
        parent::__construct($attributes);
    }

    public function organizationPcr(){
        return $this->belongsTo(OrganizationStructurePcr::class, 'organization_pcr_id');
    }

    public function mfo(){
        return $this->belongsTo(Mfo::class, 'mfo_id');
    }
}
