<?php

namespace Suiterus\Adg\Models\Mentorship;

use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\Mentorship\Mentorship;
use Suiterus\Adg\Models\Mentorship\MentorshipDate;
use Suiterus\Adg\Models\Mentorship\MentorshipInvite;
use Suiterus\Adg\Models\Mentorship\MentorshipMentor;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Suiterus\Adg\Models\Mentorship\MentorshipAttachment;

class MentorshipSession extends Model
{
    use HasFactory;

    protected $fillable = [
        'mentorship_id',
        'session_number',
        'key_points',
        'process_observation',
        'created_by',
        'updated_by',
    ];

    protected $appends = [
        'start_date',
        'end_date',
        'total_invites'
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.mentorship_sessions';
        parent::__construct($attributes);
    }

    public function mentorship(){
        return $this->belongsTo(Mentorship::class, 'mentorship_id', 'id');
    }

    public function mentors(){
        return $this->hasMany(MentorshipMentor::class, 'session_id');
    }

    public function invites(){
        return $this->hasMany(MentorshipInvite::class, 'session_id');
    }

    public function dates(){
        return $this->hasMany(MentorshipDate::class, 'session_id');
    }

    public function attachments(){
        return $this->hasMany(MentorshipAttachment::class, 'session_id');
    }

    public function getStartDateAttribute(){
        if($this->dates()->count() > 0){
            return $this->dates()->orderBy('date', 'asc')->first()->date;
        }
    }

    public function getEndDateAttribute(){
        if($this->dates()->count() > 0){
            return $this->dates()->orderBy('date', 'desc')->first()->date;
        }
    }

    public function getTotalInvitesAttribute(){
        return $this->invites()->count();
    }
}
