<?php

namespace Suiterus\Adg\Models\Mentorship;


use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\Mentorship\Mentorship;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class MentorshipReport extends Model
{
    use HasFactory;

    protected $fillable = [
        'mentorship_id',
        'goal_details',
        'goal_timeline',
        'goal_remarks',
        'realities_details',
        'realities_timeline',
        'realities_remarks',
        'options_details',
        'options_timeline',
        'options_remarks',
        'way_forward_details',
        'way_forward_timeline',
        'way_forward_remarks',
        'created_by',
        'updated_by',
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.mentorship_reports';
        parent::__construct($attributes);
    }

    public function mentorship(){
        return $this->belongsTo(Mentorship::class, 'mentorship_id', 'id');
    }

}
