<?php

namespace Suiterus\Adg\Models\Mentorship;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\Mentorship\Mentorship;
use Suiterus\Adg\Models\Mentorship\MentorshipSession;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class MentorshipMentor extends Model
{
    use HasFactory;

    protected $fillable = [
        'session_id',
        'mentor_id',
        'status'
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.mentorship_mentors';
        parent::__construct($attributes);
    }

    public function session(){
        return $this->belongsTo(MentorshipSession::class, 'session_id', 'id');
    }

    public function mentor(){
        return $this->belongsTo(User::class, 'mentor_id')->without([
            'roles',
            'permissions',
            'storage',
            'supervisor',
            'user_supervisor',
            'exitInterview',
            'userProfilePicture',
            'profileBasicInfo'
        ]);
    }
}
