<?php

namespace Suiterus\Adg\Models\Mentorship;

use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\Mentorship\MentorshipSession;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class MentorshipDate extends Model
{
    use HasFactory;

    protected $fillable = [
        'session_id',
        'date',
        'start_time',
        'end_time',
        'program_venue'
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.mentorship_dates';
        parent::__construct($attributes);
    }

    public function session(){
        return $this->belongsTo(MentorshipSession::class, 'session_id', 'id');
    }
}
