<?php

namespace Suiterus\Adg\Models\Mentorship;

use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\Mentorship\MentorshipSession;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class MentorshipAttachment extends Model
{
    use HasFactory;

    protected $fillable = [
        'session_id',
        'file_name',
        'file_path',
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.mentorship_attachments';
        parent::__construct($attributes);
    }

    public function session(){
        return $this->belongsTo(MentorshipSession::class, 'session_id', 'id');
    }
}
