<?php

namespace Suiterus\Adg\Models\Mentorship;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\Mentorship\MentorshipReport;
use Suiterus\Adg\Models\Mentorship\MentorshipSession;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Mentorship extends Model
{
    use HasFactory;

    protected $fillable = [
        'program_type',
        'program_title',
        'program_description',
        'entity_type',
        'entity_id',
        'created_by',
        'updated_by'
    ];

    protected $with = [
        'createdBy',
        'updatedBy',
        'sessions',
        'report'
    ];

    protected $appends = [
        'total_invites'
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.mentorships';
        parent::__construct($attributes);
    }

    public function entity()
    {
        return $this->morphTo('entity');
    }

    public function sessions(){
        return $this->hasMany(MentorshipSession::class, 'mentorship_id');
    }

    public function report(){
        return $this->hasOne(MentorshipReport::class, 'mentorship_id');
    }

    public function createdBy(){
        return $this->belongsTo(User::class, 'created_by')->without([
            'roles',
            'permissions',
            'storage',
            'supervisor',
            'user_supervisor',
            'exitInterview',
            'userProfilePicture',
            'profileBasicInfo'
        ]);
    }

    public function updatedBy(){
        return $this->belongsTo(User::class, 'updated_by')->without([
            'roles',
            'permissions',
            'storage',
            'supervisor',
            'user_supervisor',
            'exitInterview',
            'userProfilePicture',
            'profileBasicInfo'
        ]);
    }

    public function getTotalInvitesAttribute()
    {
        return $this->sessions->sum(function ($session) {
            return $session->invites->count();
        });
    }
}
