<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\SM\Loan;

class UserLoan extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'user_id',
        'loan_id',
        'amount',
        'number_of_payments',
        'submission_date',
        'purpose_of_loan',
        'outstanding_balance',
        'status',
        'from',
        'to',
        'created_by',
        'updated_by',
    ];

    protected $appends = [
        'formatted_from',
        'formatted_to',
        'total_amortization_amount'
    ];

    protected $with = [
        'user',
        'loanType'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.user_has_loans';
        $this->connection = env('ADG_DB_CONNECTION');
        parent::__construct($attributes);
    }

    public function user(){
        return $this->belongsTo(User::class, 'user_id', 'id')->without([
            'roles',
            'permissions',
            'storage',
            'supervisor',
            'exitInterview',
            'userProfilePicture',
            'profileBasicInfo'
        ]);
    }

    public function loanType(){
        return $this->belongsTo(Loan::class, 'loan_id', 'id');
    }

    public function getFormattedFromAttribute() {
        return date("F d, Y", strtotime($this->from));
    }

    public function getFormattedToAttribute() {
        return date("F d, Y", strtotime($this->to));
    }

    public function getTotalAmortizationAmountAttribute() {
        $status = 1; //Approved
        return LoanPaymentHistory::where([
            ['user_has_loan_id', $this->id], ['status', $status]
        ])->sum('amortization_amount');
    }
}
