<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\Payroll\PayrollEarningDeduction;

class LoanPaymentHistory extends Model
{
    use HasFactory;

    protected $connection = 'adg_db';

    protected $table = 'loan_payment_histories';

    protected $fillable = [
        'payroll_earning_deduction_id',
        'user_has_loan_id',
        'remaining_months',
        'amortization_amount',
        'outstanding_balance'
    ];

    public function payrollEarningDeduction(){
        return $this->belongsTo(PayrollEarningDeduction::class, 'payroll_earning_deduction_id', 'id');
    }

    public function userHasLoan(){
        return $this->belongsTo(UserLoan::class, 'user_has_loan_id', 'id');
    }
}
