<?php

namespace Suiterus\Adg\Models\LeaveManagement\Requests;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\LeaveManagement\Crediting\MonetizedLeaveBenefit;

class LeaveHasMonetization extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'leave_has_monetizations';

    protected $fillable = [
        'leave_id',
        'type',
        'vacation_days',
        'sick_days',
    ];

    public function leave() {
        return $this->belongsTo(Leave::class, 'leave_id', 'id');
    }

    public function monetized_leave() {
        return $this->hasOne(MonetizedLeaveBenefit::class, 'leave_monetization_id', 'id');
    }
    
}
