<?php

namespace Suiterus\Adg\Models\LeaveManagement;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LeaveType extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';
    protected $table = 'leave_types';

    protected $fillable = [
        'title',
        'description',
        'initial_points',
        'file_attachment',
        'remark',
        'default_increase',
        'increase_type',
        'status',
        'type',
        'created_by',
        'updated_by'
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.leave_types';
        parent::__construct($attributes);
    }

    public function subtypes()
    {
        return $this->hasMany(LeaveSubtype::class, 'leave_type_id', 'id');
    }

    public function eligibleGroups()
    {
        return $this->hasMany(LeaveEligibleGroup::class, 'leave_type_id', 'id');
    }

    public function eligibleUsers()
    {
        return $this->hasMany(LeaveEligibleUser::class, 'leave_type_id', 'id');
    }
}
