<?php

namespace Suiterus\Adg\Models\LeaveManagement;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\LeaveManagement\LeaveType;

class LeaveSubtype extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'leave_subtypes';

    protected $fillable = [
        'leave_type_id',
        'title',
        'status',
        'additional_info',
    ];

    protected $appends = [
        'full_title'
    ];

    public function getFullTitleAttribute() {
        $additional_info = $this->additional_info == '' ? '' : ' (' . $this->additional_info . ')';
        return $this->title . $additional_info;
    }

    public function type() {
        return $this->belongsTo(LeaveType::class, 'leave_type_id', 'id');
    }
}
