<?php

namespace Suiterus\Adg\Models\LeaveManagement;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LeaveEligibleUser extends Model
{
    use HasFactory;

    protected $connection = 'adg_db';
    protected $table = 'leave_eligible_users';

    protected $fillable = [
        'leave_type_id',
        'user_id',
        'created_by'
    ];

    public function leaveType()
    {
        return $this->belongsTo(LeaveType::class, 'leave_type_id', 'id');
    }

    public function user()
    {
        return $this->belongsTo(Role::class, 'user_id', 'id');
    }
}
