<?php

namespace Suiterus\Adg\Models\LeaveManagement;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LeaveEligibleGroup extends Model
{
    use HasFactory;

    protected $connection = 'adg_db';
    protected $table = 'leave_eligible_groups';

    protected $fillable = [
        'leave_type_id',
        'group_id',
        'created_by'
    ];

    public function leaveType()
    {
        return $this->belongsTo(LeaveType::class, 'leave_type_id', 'id');
    }

    public function group()
    {
        return $this->belongsTo(Role::class, 'group_id', 'id');
    }
}
