<?php

namespace Suiterus\Adg\Models\LeaveManagement;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LeaveCreditHistory extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'leave_type_id',
        'credits',
        'resulting_balance',
        'leave_adjustment_type',
        'remarks',
        'period',
        'created_by',
    ];

    public function __construct(array $attributes = [])
    {
        $this->setConnection(env('ADG_DB_CONNECTION'));
        $this->setTable(env("ADG_DB_DATABASE") . '.leave_credit_histories');
        parent::__construct($attributes);
    }
}
