<?php

namespace Suiterus\Adg\Models\LeaveManagement;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\LeaveManagement\Requests\Leave;

class LeaveApprover extends Model
{
    use HasFactory;

    protected $connection = 'adg_db';
    protected $table = 'leave_applications';

    protected $fillable = [
        'leave_id',
        'approver_id',
        'remarks',
        'status',
    ];

    protected $with = [
        'approver'
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.leave_approvers';
        parent::__construct($attributes);
    }

    public function leave()
    {
        return $this->belongsTo(Leave::class, 'leave_id', 'id');
    }

    public function approver()
    {
        return $this->belongsTo(User::class, 'approver_id', 'id')->without([
            'roles',
            'permissions',
            'storage',
            'supervisor',
            'user_supervisor',
            'exitInterview',
            'userProfilePicture',
            'profileBasicInfo'
        ]);
    }
}
