<?php

namespace Suiterus\Adg\Models\LeaveManagement;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class LeaveApplication extends Model
{
    use HasFactory, SoftDeletes;
    
    protected $connection = 'adg_db';
    protected $table = 'leave_applications';

    protected $fillable = [
        'user_id',
        'leave_id',
        'vacation_leave',
        'sick_leave',
        'forced_leave',
        'special_privilege_leave',
        'created_by',
        'updated_by'
    ];

    public function __construct(array $attributes = []) {
        $this->table = env('ADG_DB_DATABASE') . '.leave_applications';
        parent::__construct($attributes);
    }

    public function leave() {
        return $this->belongsTo(Leave::class, 'leave_id', 'id');
    }

    
}
