<?php

namespace Suiterus\Adg\Models\LeaveManagement;

use Illuminate\Support\Facades\Log;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\Payroll\Allowance;
use Suiterus\Adg\Models\Salary\EmployeeAllowance;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Suiterus\Adg\Models\LeaveManagement\Requests\Leave;
use Suiterus\Adg\Models\LeaveManagement\Crediting\LeaveBalance;

class LeaveAllowance extends Model
{
    use HasFactory;

    protected $fillable = [
        'leave_id',
        'allowance_id',
        'type'
    ];

    public function __construct(array $attributes = []) {
        $this->table = env('ADG_DB_DATABASE') . '.leave_allowances';
        parent::__construct($attributes);
    }

    public function leave(){
        return $this->belongsTo(Leave::class, 'leave_id', 'id');
    }

    public function employeeAllowance(){
        return $this->belongsTo(EmployeeAllowance::class, 'allowance_id', 'allowance_id')->when($this->leave, function($query) {
            $query->where('user_id', $this->leave->user_id);
        });
    }
}
