<?php

namespace Suiterus\Adg\Controllers\LeaveManagement\Crediting;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\LeaveManagement\Requests\Leave;

class TerminalLeaveBenefit extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';
    protected $table = 'terminal_leave_benefits';

    protected $fillable = [
        'leave_id',
        'computed_amount'
    ];

    public function leave() {
        return $this->belongsTo(Leave::class, 'leave_id', 'id');
    }
}
