<?php

namespace Suiterus\Adg\Models\LeaveManagement\Crediting;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\LeaveManagement\Requests\LeaveHasMonetization;

class MonetizedLeaveBenefit extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'monetized_leave_benefits';

    protected $fillable = [
        'leave_monetization_id',
        'deducted_vacation_leave_balance',
        'deducted_sick_leave_balance',
        'vacation_leave_balance',
        'sick_leave_balance',
        'total_points',
        'monetized_amount'
    ];

    public function leave_monetization() {
        return $this->belongsTo(LeaveHasMonetization::class,'leave_monetized_id', 'id');
    }

    public function getMonetizedAmountAttribute($value) {
        return number_format($value, 2, '.', ',');
    }
}
