<?php

namespace Suiterus\Adg\Models\LeaveManagement\Crediting;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\LeaveManagement\Requests\Leave;

class LeaveWithoutPay extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'leave_id',
        'deducted_points',
        'created_by',
        'updated_by'
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.leave_without_pays';
        parent::__construct($attributes);
    }

    public function leave() {
        return $this->belongsTo(Leave::class, 'leave_id', 'id');
    }
}
