<?php

namespace Suiterus\Adg\Models\LeaveManagement\Crediting;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LeaveCreditEarning extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';
    protected $table = 'leave_credit_earnings';

    protected $fillable = [
        'leave_balance_id',
        'period',
        'remarks',
        'credits',
        'resulting_balance',
        'created_by',
        'updated_by'
    ];

    public function __construct(array $attributes = []) {
        $this->table = env('ADG_DB_DATABASE') . '.leave_credit_earnings';
        parent::__construct($attributes);
    }

    public function leave_balance() {
        return $this->belongsTo(LeaveBalance::class, 'leave_balance_id', 'id');
    }

    public function user() {
        return $this->leave_balance->user;
    }

    public function leave_type() {
        return $this->leave_balance->leave_type;
    }

}
