<?php

namespace Suiterus\Adg\Models\LeaveManagement\Crediting;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LeaveCreditDeduction extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';
    protected $table = 'leave_credit_deductions';

    protected $fillable = [
        'period',
        'remarks',
        'credits',
        'resulting_balance',
        'created_by',
        'updated_by'
    ];

    public function __construct(array $attributes = []) {
        $this->table = env('ADG_DB_DATABASE') . '.leave_credit_deductions';
        parent::__construct($attributes);
    }

    public function deductable() {
        return $this->morphTo();
    }

}
