<?php

namespace Suiterus\Adg\Models\LeaveManagement\Crediting;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\LeaveManagement\LeaveType;

class LeaveBalance extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'leave_balances';

    protected $fillable = [
        'user_id',
        'leave_type_id',
        'balance',
        'created_by',
        'updated_by'
    ];


    // Relationships
    public function __construct(array $attributes = []) {
        $this->table = env('ADG_DB_DATABASE') . '.leave_balances';
        parent::__construct($attributes);
    }

    public function user() {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function leave_type() {
        return $this->belongsTo(LeaveType::class, 'leave_type_id', 'id');
    }

    public function credit_earnings() {
        return $this->hasMany(LeaveCreditEarning::class, 'leave_balance_id', 'id');
    }

    // Methods
    public function scopeGetBalance($leave) {
        return $this->where('leave_type_id', $leave)->first();
    }

}
