<?php

namespace Suiterus\Adg\Models\LearningDevelopment;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TrainingBond extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'training_bonds';

    protected $fillable = [
        'user_id',
        'employee_type',
        'department',
        'position',
        'date_from',
        'date_to',
        'status',
        'duration',
        'wave_option',
        'created_by',
        'updated_by'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.training_bonds';
        parent::__construct($attributes);
    }

    public function user() {
        return $this->belongsTo('App\Models\User', 'user_id', 'id');
    }

    public function department() {
        return $this->belongsTo('Suiterus\Adg\Models\SM\Department', 'department', 'id');
    }

    public function employeeType() {
        return $this->belongsTo('Suiterus\Adg\Models\SM\EmployeeType', 'employee_type', 'id');
    }

    public function position() {
        return $this->belongsTo('Suiterus\Hrjp\Models\Position', 'position', 'id');
    }
    
}
