<?php

namespace Suiterus\Adg\Models\LearningDevelopment;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Demerit extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'demerits';

    protected $fillable = [
        'user_id',
        'subject',
        'effect_date',
        'message',
        'points',
        'status',
        'created_by',
        'updated_by',
    ];

    protected $appends = [
        'formatted_effect_date'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.demerits';
        parent::__construct($attributes);
    }

    public function user() {
        return $this->belongsTo('App\Models\User', 'user_id', 'id');
    }

    public function getFormattedEffectDateAttribute() {
        $formatted = date("F d, Y", strtotime($this->effect_date));
        return $formatted;
    }
}
