<?php

namespace Suiterus\Adg\Models\HRExit\ExitInterview;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ExitInterview extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';
    protected $table = 'exit_interviews';

    protected $fillable = [
      'user_id',
      'date',
      'status',
      'remarks',
      'attachment',
      'created_by',
      'updated_by'
    ];

    public function __construct(array $attributes = []) {
      $this->table = env('ADG_DB_DATABASE') . '.exit_interviews';
      parent::__construct($attributes);
  }

    public function user(){
        return $this->belongsTo(User::class, 'user_id', 'id');
    }
    
}
