<?php

namespace Suiterus\Adg\Models\HRExit;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\SM\Department;

class ClearanceCompliance extends Model
{
    use HasFactory, SoftDeletes;
    protected $connection = 'adg_db';
    protected $fillable = [

        'user_id',
        'clearance_id',
        'department_id',
        'assigned_personal_id',
        'action_item',
        'attachment',
        'timestamp',
        'created_by',
        'updated_by',
        
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.clearance_compliances';
        parent::__construct($attributes);
    }

    public function clearance() {
        return $this->belongsTo(Clearance::class, 'clearance_id', 'id');
    }

    public function department() {
        return $this->belongsTo(Department::class, 'department_id', 'id');
    }

    public function assigned_personnel() {
        return $this->belongsTo(User::class, 'assigned_personal_id', 'id');
    }

}
