<?php

namespace Suiterus\Adg\Models\HRExit;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;



class Clearance extends Model
{
    use HasFactory, SoftDeletes;
    protected $connection = 'adg_db';
    protected $table = 'clearances';
    protected $fillable = [
        'user_id',
        'start_date',
        'status',
        'sent_to_employee',
        'timestamps',
        'created_by',
        'updated_by'  
    ];

    protected $appends = [
        'attachments_available'
    ];

    public function __construct(array $attributes = []) {
        $this->table = env('ADG_DB_DATABASE') . '.clearances';
        parent::__construct($attributes);
    }
    
    public function ClearanceHasForm(){
        return $this->hasMany(ClearanceCompliance::class, 'clearance_id', 'id');
    }

    public function user() {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function getAttachmentsAvailableAttribute() {
        foreach($this->ClearanceHasForm as $compliance) {
            if($compliance->attachment !== null && $compliance->attachment !== '') {
                return true;
            } 
        }
        return false;
    }
}