<?php

namespace Suiterus\Adg\Models\EmployeeCases;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EmployeeCase extends Model
{
    protected $connection = 'adg_db';

    protected $table = 'employee_cases';

    protected $fillable = [
        'user_id',
        'complaint_title',
        'date_of_complaint',
        'action_taken',
        'date_of_action',
        'status',
        'created_by',
        'updated_by',
    ];

    protected $appends = [
        'formatted_date_of_complaint',
        'formatted_date_of_action'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.employee_cases';
        parent::__construct($attributes);
    }

    public function user() {
        return $this->belongsTo('App\Models\User', 'user_id', 'id');
    }

    public function getFormattedDateOfComplaintAttribute() {
        $formatted = date("F d, Y", strtotime($this->date_of_complaint));
        return $formatted;
    }

    public function getFormattedDateOfActionAttribute() {
        $formatted = date("F d, Y", strtotime($this->date_of_action));
        return $formatted;
    }
}
