<?php

namespace Suiterus\Adg\Models\EMI;

use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\SM\EmployeeType;
use Suiterus\Adg\Models\EMI\AppointmentForm;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class EmployeeTypeHistory extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'employee_type_histories';

    protected $fillable = [
        'user_id',
        'employee_type_id',
        'date_of_effectivity',
        'status',
        'created_by',
        'updated_by'
    ];

    protected $appends =[
        'formatted_date_of_effectivity'
    ];

    public function user(){
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function employeeType(){
        return $this->belongsTo(EmployeeType::class, 'employee_type_id', 'id');
    }

    public function getFormattedDateOfEffectivityAttribute(){
        return date("F d, Y", strtotime($this->date_of_effectivity));
    }
    
    public function appointmentForm(){
        return $this->hasMany(AppointmentForm::class, 'employee_type_history_id', 'id');
    }

}
