<?php

namespace Suiterus\Adg\Models\EMI;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;
use Suiterus\Adg\Models\SM\Branch;
use Suiterus\Adg\Models\SM\Corporation;
use Suiterus\Adg\Models\SM\Department;
use Suiterus\Adg\Models\SM\Division;
use Suiterus\Adg\Models\SM\EmployeeType;
use Suiterus\Adg\Models\SM\Corporation_history;
use Suiterus\Adg\Models\SM\Branch_history;
use Suiterus\Adg\Models\SM\Division_history;
use Suiterus\Adg\Models\SM\Department_history;
use Suiterus\Adg\Models\SM\DesignationHistory;
use Suiterus\Hrjp\Models\Position;
use Suiterus\Adg\Models\EMI\EmployeeTypeHistory;
use Suiterus\Adg\Models\SM\Office;
use Suiterus\Adg\Models\SM\Section;
use Suiterus\Adg\Models\SM\Unit;
use Suiterus\Hrjp\Models\ItemCode;

class EmployeeMetaInfo extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'employee_meta_info';

    protected $fillable = [
        'user_id',
        'employee_id',
        'employee_type',
        'corp_id',
        'branch_id',
        'division_id',
        'department_id',
        'office_id',
        'section_id',
        'unit_id',
        'salary_id',
        'item_code_id',
        'position_id',
        'date_hired',
        'created_by',
        'modified_by'
    ];

    protected $with = [
        'corporation',
        'branch',
        'division',
        'department',
        'employeeType',
        'position',
        'itemCode'
    ];

    public static function boot()
    {
        parent::boot();
        static::created(function ($record) {
            DesignationHistory::create([
                'user_id'               =>  $record->user_id,
                'corp_id'               =>  $record->corp_id,
                'branch_id'             =>  $record->branch_id,
                'division_id'           =>  $record->division_id,
                'department_id'         =>  $record->department_id,
                'date_of_designation'   =>  now(),
                'created_by'            =>   Auth::id()
            ]);

            EmployeeTypeHistory::create([
                'user_id'               =>  $record->user_id,
                'employee_type_id'      =>  $record->employee_type,
                'date_of_effectivity'   =>  now(),
                'status'                =>  1,
                'created_by'            =>  Auth::id()
            ]);
        });


    }

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.employee_meta_info';
        parent::__construct($attributes);
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function corporation()
    {
        return $this->belongsTo(Corporation::class, 'corp_id', 'id');
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class, 'branch_id', 'id');
    }

    public function office(){
        return $this->belongsTo(Office::class, 'office_id', 'id');
    }

    public function unit(){
        return $this->belongsTo(Unit::class, 'unit_id', 'id');
    }

    public function section(){
        return $this->belongsTo(Section::class, 'section_id', 'id');
    }

    public function division()
    {
        return $this->belongsTo(Division::class, 'division_id', 'id');
    }

    public function department()
    {
        return $this->belongsTo(Department::class, 'department_id', 'id');
    }

    public function employeeType()
    {
        return $this->belongsTo(EmployeeType::class, 'employee_type', 'id');
    }

    public function position()
    {
        return $this->belongsTo(Position::class, 'position_id', 'id');
    }

    public function itemCode()
    {
        return $this->belongsTo(ItemCode::class, 'item_code_id', 'id');
    }
}
