<?php

namespace Suiterus\Adg\Models\EMI;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\EMI\EmployeeExtraFieldGroup;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Suiterus\Adg\Models\PDS\UpdatePDS;

class EmployeeExtraFieldGroupHistory extends Model
{
    use HasFactory;

    protected $connection = 'adg_db';

    protected $table = 'employee_extra_field_group_histories';

    protected $fillable = [
        'eefg_id',
        'file_attachment',
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.employee_extra_field_group_histories';
        parent::__construct($attributes);
    }

    public function employeeExtraFieldGroup(){
        return $this->belongsTo(EmployeeExtraFieldGroup::class, 'eefg_id', 'id');
    }

    public function newUpdatePDS(){
        return $this->hasMany(UpdatePDS::class, 'eefg_history_id', 'id');
    }
}
