<?php

namespace Suiterus\Adg\Models\EMI;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Suiterus\Adg\Models\EMI\EmployeeExtraFieldGroupHistory;

class EmployeeExtraFieldGroup extends Model
{
    use HasFactory;

    protected $connection = 'adg_db';

    protected $table = 'employee_extra_field_groups';

    protected $fillable = [
        'user_id',
        'name',
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.employee_extra_field_groups';
        parent::__construct($attributes);
    }

    public function user(){
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function employeeExtraFieldGroupHistory(){
        return $this->hasMany(EmployeeExtraFieldGroupHistory::class, 'eefg', 'id');
    }
}
