<?php

namespace Suiterus\Adg\Models\EMI;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Suiterus\Adg\Models\EMI\EmployeeExtraField;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\PDS\PDSPerPosition;
use Suiterus\Adg\Models\PDS\UpdatePDS;

class EmployeeExtraFieldColumn extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $fillable = [
        'eef_id',
        'field_name',
        'field_value',
        'field_type',
        'field_status',
        'field_label',
        'created_by',
        'modified_by',
    ];

    protected $with = [
        'updatePDS'
    ];

    protected $appends = [
        'formatted_updated_at'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.employee_extra_field_columns';
        parent::__construct($attributes);
    }

    public function updatePDS(){
        return $this->hasOne(UpdatePDS::class, 'eefc_id', 'id');
    }

    public function employeeExtraField(){
        return $this->belongsTo(EmployeeExtraField::class, 'eef_id', 'id');
    }

    public function pdsPerPosition(){
        return $this->hasMany(PDSPerPosition::class, 'eefc_id', 'id');
    }

    public function getFormattedUpdatedAtAttribute(){
        return date("F j, Y", strtotime($this->updated_at));
    }

}

