<?php

namespace Suiterus\Adg\Models\EMI;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\EMI\EmployeeExtraFieldGroup;
use Suiterus\Adg\Models\EMI\EmployeeExtraFieldColumn;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class EmployeeExtraField extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $fillable = [
        'user_id',
        'eefg_id',
        'table_name',
        'created_by',
        'modified_by'
    ];

    protected $with = [
        'employeeExtraFieldColumn'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.employee_extra_fields';
        parent::__construct($attributes);
    }

    public function employeeExtraFieldColumn(){
        return $this->hasMany(EmployeeExtraFieldColumn::class, 'eef_id', 'id')->withTrashed();
    }

    public function employeeExtraFieldGroup(){
        return $this->belongsTo(EmployeeExtraFieldGroup::class, 'eefg_id', 'id');
    }
}
