<?php

namespace Suiterus\Adg\Models\EMI;

use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\EMI\EmployeeTypeHistory;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class AppointmentForm extends Model
{
    use HasFactory;

    protected $connection = 'adg_db';

    protected $fillable = [
        'employee_type_history_id',
        'file_path',
        'created_by',
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.appointment_forms';
        parent::__construct($attributes);
    }

    public function employeeTypeHistory(){
        return $this->belongsTo(EmployeeTypeHistory::class, 'employee_type_history_id', 'id');
    } 

}
