<?php

namespace Suiterus\Adg\Models\Approvals;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserUndertime extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';
    protected $fillable = [
        'user_id',
        'start_date',
        'start_time',
        'end_date',
        'end_time',
        'total_no_of_hours',
        'undertime_justification',
        'status',
        'created_by',
        'created_at',
        'updated_at',
        'updated_by',
        'deleted_at'
    ];

    protected $appends = [
        'formatted_start_date',
        'formatted_end_date',
        'formatted_start_time',
        'formatted_end_time',
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.user_undertimes';
        parent::__construct($attributes);
    }

    public function user(){
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function getFormattedStartDateAttribute(){
        return date("F d, Y", strtotime($this->start_date));
    }
   
    public function getFormattedEndDateAttribute(){
        return date("F d, Y", strtotime($this->end_date));
    }
    
    public function getFormattedStartTimeAttribute(){
        return date("h:i a", strtotime($this->start_time));
    }

    public function getFormattedEndTimeAttribute(){
        return date("h:i a", strtotime($this->end_time));
    }

}