<?php

namespace Suiterus\Adg\Models\Approvals;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TrainingApproval extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'training_approvals';

    protected $fillable = [
        'employee_id',
        'title',
        'date',
        'type',
        'status',
        'company',
        'created_by',
        'updated_by'
    ];

    protected $append = [
        'formatted_effect_date'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.training_approvals';
        parent::__construct($attributes);
    }

    public function user() {
        return $this->belongsTo('App\Models\User', 'employee_id', 'id');
    }

    public function getFormattedEffectDateAttribute() {
        return date("F d, Y", strtotime($this->date));
    }
}